%%%%%%%%%%%%%% Draw an example personalized coauthorship network %%%%%%%%%%

name_list = {'Raymond Carroll'};

sqnq_pv = zeros(length(name_list),1); 
sgnq = zeros(length(name_list),1); 

for name_list_idx = 1:length(name_list)
    
    person = name_list(name_list_idx);

    ID = find(strcmp(authorNames, person));
    neighbors = find(A(ID,:)>0);
    sets = [neighbors, ID];
    m = length(sets);
    A_person = A(sets,sets);
    Degs = sum(A_person,2);  %%% degrees in the penetwork
    names = authorNames(sets);
    Nau = sum(A(sets,:),2);  %%% #coauthors (degrees in the whole network - 1)
    
    A_person2 = A(neighbors, neighbors);  %%% remove the hub node
    bins = conncomp(graph(A_person2));
    bins = [bins';Inf];
    
    
    pVals = zeros(m,1);
    for i = 1:m
        tempnode = sets(i);
        tempsets = union(find(A(tempnode,:)>0), tempnode);
        A_temp = A(tempsets, tempsets); 
        [pVals(i),~,~] = SgnQ(A_temp); %%% p-values based on their own personalized networks
    end
    
    %%% sort the nodes and print %%%%%%%%%%%%%%%%%%%
    [~, ix] = sort(Nau, 'descend');
    A_person = A_person(ix,ix);
    names = names(ix);
    Nau = Nau(ix);
    Degs = Degs(ix);
    pVals = pVals(ix);
    bins = bins(ix);
    % table(names, Degs, Nau, pVals, bins)
    
    %%% if needed, run community detection on the giant component %%%%%%%%%
    K = 2;
    giant = find(bins==mode(bins));
    templabels = SCORE(A_person(giant,giant) + eye(length(giant)), K);
    labels = zeros(m,1);
    labels(giant) = templabels;
    % table(names, Degs, Nau, pVals, labels)
    
    %%%pvals and standardized tests 
    [sgnq_pv(name_list_idx),~,sgnq(name_list_idx)] = SgnQ(A_person(giant, giant));
    
%     figure 
    
    %%%plot pruned graph
    G = graph(A_person(giant,giant)); 
    plot(G,'NodeLabel',labels(giant))
end 

